% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_match.R
\name{fuzzy_match_species_within_genus}
\alias{fuzzy_match_species_within_genus}
\title{Fuzzy Match Species within Genus}
\usage{
fuzzy_match_species_within_genus(df, target_df = NULL)
}
\arguments{
\item{df}{A tibble containing the species data to be matched.}

\item{target_df}{A tibble representing the threatened species database
containing the reference list of threatened species.}
}
\value{
A tibble with an additional logical column fuzzy_match_species_within_genus,
indicating whether the specific epithet was successfully fuzzy matched within
the matched genus (`TRUE`) or not (`FALSE`).
}
\description{
This function attempts to fuzzy match species names within a genus to the
threatened species database using fuzzyjoin::stringdist for fuzzy matching.
}
\details{
If multiple species match with the same string distance (ambiguous matches),
a warning is issued and the first match is automatically selected. To
examine ambiguous matches in detail, use \code{\link{get_ambiguous_matches}}
on the result object with \code{type = "species"}.

**IMPROVED**: Ambiguous match attributes now include threat category and
accepted names for better decision-making.
}
\seealso{
\code{\link{get_ambiguous_matches}} to retrieve ambiguous match details
}
\keyword{internal}
