% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals_api.R
\name{is_endemic_peru}
\alias{is_endemic_peru}
\title{Check if species are endemic to Peru}
\usage{
is_endemic_peru(splist, return_logical = FALSE, filter_exact = FALSE)
}
\arguments{
\item{splist}{Character vector of species names}

\item{return_logical}{Logical. If TRUE, returns logical vector (TRUE/FALSE/NA).
If FALSE, returns descriptive character vector (default: FALSE)}

\item{filter_exact}{Logical. If TRUE, only considers exact matches (default: FALSE)}
}
\value{
If return_logical = FALSE: Character vector with endemism status
If return_logical = TRUE: Logical vector (TRUE = endemic, FALSE = not endemic,
NA = not found or endemism unknown)
}
\description{
Simplified wrapper specifically for checking endemism status of mammals
in Peru. Only evaluates species that are confirmed to occur in Peru.
}
\examples{

species <- c("Panthera onca",
             "Atelocynus microtis",
             "Felis catus",
             "Myotis bakeri")

is_endemic_peru(species)
# Descriptive output
tibble::tibble(splist = species) |>
  dplyr::mutate(endemic = is_endemic_peru(splist))

}
