% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sim.meta}
\alias{sim.meta}
\alias{sim.meta.comm}
\alias{sim.meta.phy.comm}
\title{Simulate a meta-community (and its phylogeny)}
\usage{
sim.meta.comm(size = 10, n.spp = 8, timesteps = 10, p.migrate = 0.05,
  env.lam = 10, abund.lam = 5, stoch.lam = 1)

sim.meta.phy.comm(size = 10, n.spp = 8, timesteps = 10, p.migrate = 0.3,
  env.lam = 10, abund.lam = 5, stoch.lam = 1, p.speciate = 0.05)
}
\arguments{
\item{size}{the length and width of the meta-community in grid
cells}

\item{n.spp}{number of species}

\item{timesteps}{number of time-steps (each discrete)}

\item{p.migrate}{probability that a group of species in each grid
cell will migrate to another grid cell each timestep (i.e., 10
cells occuped by a species --> 10*\code{p.migrate} chance of
migration)}

\item{env.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution used to distribute environmental quality; essentially
the carrying capacity (for each species separately) for that cell}

\item{abund.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution used to distribute initial abundances and abundance
after migration}

\item{stoch.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution of noise added to the next step abundance
calculation. With equal chance, this is taken as either a positive
or a negative number (see details if you're confused as to why this
is Poisson!)}

\item{p.speciate}{probabilty that, at each timestep, a species will
speciate. A species can only speciate, migrate, or reproduce if it
has individuals!}
}
\value{
List with the species abundances (as a 3D array) and the
environmental quality (carrying capacities) for
\code{sim.meta.comm}. For \code{sim.meta.phy.comm}, also a
phylogeny of species and a lookup table from the abundance array to
the phylogeny.

List with the species abundances (as a 3D array), the
environmental quality (carrying capacities), the phylogeny of
species (which generates warnings when plotted, don't ask me why!),
and a lookup table from the abundance array to the phylogeny.
}
\description{
Simulate a meta-community (and the resulting phylogeny) based on
responses to environmental gradients

\code{sim.meta.phy.comm} simulate a (sort of) meta-community
}
\details{
\code{sim.meta.comm} simulates species moving through a
metacommunity. At each time-step each cell's next abundance for
each species is \code{env.quality} - \code{current.abundance} +
\code{stochastic}, and a species gets as many chances to migrate in
each time-step as it has cells (the same cell could migrate
multiple times). I use a Poisson for everything because I don't
want half-species (these are individuals), and keeping everything
in Poisson makes it easier to compare the relative rates of
everything.

\code{sim.meta.phy.comm} As above, but with a simulation of
phylogeny as well - there are no additional extinction parameters,
since extinction happens as a natural consequence of ecological
interactions.
}
\note{
\code{\link{scape}} is a much more sophisticated simulation
of the biogeography, but requires you to supply a phylogeny. You
pays your money, you makes your choice.
}
\author{
Will Pearse

Will Pearse
}
\seealso{
\code{\link{sim.phy}} \code{\link{scape}}
}

