/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.functions;

import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.functions.ExponentialFunction;
import net.sf.eps2pgf.ps.resources.functions.StitchingFunction;

public class PSFunction {
    private double[] domain;
    private double[] range;
    private int nrInputValues;
    private int nrOutputValues;

    public static PSFunction newFunction(PSObjectDict pSObjectDict) throws PSError {
        PSFunction pSFunction;
        PSObject pSObject = pSObjectDict.lookup("FunctionType");
        if (pSObject == null) {
            throw new PSErrorRangeCheck();
        }
        switch (pSObject.toInt()) {
            case 0: {
                throw new PSErrorUnimplemented("FunctionType 0");
            }
            case 2: {
                pSFunction = new ExponentialFunction(pSObjectDict);
                break;
            }
            case 3: {
                pSFunction = new StitchingFunction(pSObjectDict);
                break;
            }
            default: {
                throw new PSErrorRangeCheck();
            }
        }
        return pSFunction;
    }

    void loadCommonEntries(PSObjectDict pSObjectDict) throws PSErrorUndefined, PSErrorTypeCheck {
        this.domain = pSObjectDict.get("Domain").toArray().toDoubleArray();
        this.nrInputValues = (int)Math.floor((double)this.domain.length / 2.0);
        try {
            PSObject pSObject = pSObjectDict.get("Range");
            this.range = pSObject.toArray().toDoubleArray();
            this.nrOutputValues = (int)Math.floor((double)this.range.length / 2.0);
        }
        catch (PSErrorUndefined pSErrorUndefined) {
            this.range = new double[0];
            this.nrOutputValues = -1;
        }
    }

    public double[] evaluate(double[] dArray) throws PSErrorRangeCheck, PSErrorUnimplemented {
        throw new PSErrorUnimplemented("Evaluating functions of this type");
    }

    double[] evaluatePreProcess(double[] dArray) throws PSErrorRangeCheck {
        if (dArray.length != this.nrInputValues) {
            throw new PSErrorRangeCheck();
        }
        double[] dArray2 = new double[this.nrInputValues];
        for (int i = 0; i < this.nrInputValues; ++i) {
            dArray2[i] = dArray[i] < this.domain[2 * i] ? this.domain[i] : (dArray[i] > this.domain[2 * i + 1] ? this.domain[2 * i + 1] : dArray[i]);
        }
        return dArray2;
    }

    double[] evaluatePostProcess(double[] dArray) {
        if (this.range.length > 0) {
            for (int i = 0; i < this.nrOutputValues; ++i) {
                if (dArray[i] < this.range[2 * i]) {
                    dArray[i] = this.range[2 * i];
                    continue;
                }
                if (!(dArray[i] > this.range[2 * i + 1])) continue;
                dArray[i] = this.range[2 * i + 1];
            }
        }
        return dArray;
    }

    void setNrOutputValues(int n) {
        this.nrOutputValues = n;
    }

    int getNrOutputValues() {
        return this.nrOutputValues;
    }

    double getDomain(int n) {
        return this.domain[n];
    }
}

