/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

public class ASCII85Encode
extends OutputStream {
    private OutputStream out;
    private int[] buffer = new int[4];
    private int bufferSize = 0;
    private byte[] asciiChars = new byte[5];
    private int currentLineLength = 0;
    private boolean closeTarget;

    public ASCII85Encode(OutputStream outputStream, PSObjectDict pSObjectDict) throws PSError {
        this.out = outputStream;
        PSObject pSObject = null;
        if (pSObjectDict != null) {
            pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSETARGET);
        }
        this.closeTarget = pSObject != null ? pSObject.toBool() : false;
    }

    public void write(int n) throws IOException {
        this.buffer[this.bufferSize++] = n & 0xFF;
        if (this.bufferSize == 4) {
            this.encodeAndWriteBuffer();
        }
    }

    private void encodeAndWriteBuffer() throws IOException {
        int n = this.encodeBytes(this.buffer, this.bufferSize, this.asciiChars);
        this.out.write(this.asciiChars, 0, n);
        this.bufferSize = 0;
        this.currentLineLength += n;
        if (this.currentLineLength > 75) {
            this.out.write(10);
            this.currentLineLength = 0;
        }
    }

    private int encodeBytes(int[] nArray, int n, byte[] byArray) {
        int n2;
        if (n < 4) {
            for (int i = n; i < 4; ++i) {
                nArray[i] = 0;
            }
        }
        long l = 0L;
        for (n2 = 0; n2 < 4; ++n2) {
            l = l << 8 | (long)this.buffer[n2];
        }
        if (l > 0L) {
            for (int i = 4; i >= 0; --i) {
                byArray[i] = (byte)(33L + l % 85L);
                l /= 85L;
            }
            n2 = n + 1;
        } else {
            byArray[0] = 122;
            n2 = 1;
        }
        return n2;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException();
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.encodeAndWriteBuffer();
        String string = "\n~>\n";
        this.out.write(string.getBytes());
        if (this.closeTarget) {
            this.out.close();
        }
        this.out = null;
    }
}

