% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multpostp.R
\name{MultPostP.design}
\alias{MultPostP.design}
\title{The stopping boundaries based on the multiple outcomes criterion}
\usage{
MultPostP.design(type, nmax, a.vec, p0, theta, optimize)
}
\arguments{
\item{type}{type of boundaries: "efficacy" or "futility" or "toxicity".}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{a.vec}{the hyperparameter vector of the Dirichlet prior for the experimental drug.}

\item{p0}{the prespecified reseponse rate for efficacy or toxicity.}

\item{theta}{the cutoff probability: typically, \eqn{\theta = [0.9, 0.99]} for efficacy, \eqn{\theta = [0.01, 0.1]} for futility, and \eqn{\theta = [0.95, 1]} for toxicity.}

\item{optimize}{logical value, if optimize=TRUE, then only output the minimal sample size for the same number of futility boundaries and maximal sample size for the same number efficacy boundaries}
}
\value{
\item{boundset}{the boundaries set: \eqn{U_n} or \eqn{L_n} for the experimental drug efficacy or futility; \eqn{T_n} for the experimental drug toxicity.}
}
\description{
The design function to sequentially monitor sample size and boundary based on Thall, Simon and Estey's criterion.
}
\examples{
## Using vague prior Unif(0,1)
MultPostP.design(type="futility",nmax = 30,a.vec = c(1,1,1,1),p0 = 0.15, theta = 0.05)
MultPostP.design(type="efficacy",nmax = 30,a.vec = c(1,1,1,1),p0 = 0.15, theta = 0.9)
MultPostP.design(type="toxicity",nmax = 30,a.vec = c(1,1,1,1),p0 = 0.15, theta = 0.95)
}
\references{
Thall, Peter F., Richard M. Simon, and Elihu H. Estey. (1995).
\emph{Bayesian sequential monitoring designs for single-arm clinical trials with multiple outcomes.}
\emph{Statistics in medicine} \strong{14.4}: 357-379.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

