% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{rtma_qqplot}
\alias{rtma_qqplot}
\title{Diagnostic quantile-quantile plot for a right-truncated meta-analysis}
\usage{
rtma_qqplot(rtma)
}
\arguments{
\item{rtma}{Output of \code{phacking_rtma()}.}
}
\value{
No return value, draws a plot.
}
\description{
To assess the fit of right-truncated meta-analysis and possible violations of
its distributional assumptions, plots the fitted cumulative distribution
function (CDF) of the published nonaffirmative estimates versus their
empirical CDF. If the points do not adhere fairly closely to a 45-degree
line, the right-truncated meta-analysis may not fit adequately.
}
\examples{
\donttest{
set.seed(22)
lodder_rtma <- phacking_rtma(lodder$yi, lodder$vi, parallelize = FALSE)
rtma_qqplot(lodder_rtma)
}
}
