% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{phacking_meta}
\alias{phacking_meta}
\title{Right-truncated meta-analysis}
\usage{
phacking_meta(
  yi,
  vi,
  sei,
  favor_positive = TRUE,
  alpha_select = 0.05,
  ci_level = 0.95,
  stan_control = list(adapt_delta = 0.98, max_treedepth = 20),
  parallelize = TRUE
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{ci_level}{Confidence interval level (as proportion) for the corrected
point estimate. (The alpha level for inference on the corrected point
estimate will be calculated from \code{ci_level}.)}

\item{stan_control}{List passed to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} as the \code{control}
argument.}

\item{parallelize}{Logical indicating whether to parallelize sampling.}
}
\value{
An object of class \code{\link[metabias:metabias-class]{metabias::metabias()}}, a list containing:
\describe{
\item{data}{A tibble with one row per study and the columns
\code{yi}, \code{vi}, \code{sei}, \code{affirm}.}
\item{values}{A list with the elements \code{favor_positive}, \code{alpha_select}, \code{ci_level}, \code{k}, \code{k_affirmative}, \code{k_nonaffirmative}, \code{optim_converged}.
\code{optim_converged} indicates whether the optimization to find
the posterior mode converged.}
\item{stats}{A tibble with two rows and the columns
\code{param}, \code{mode}, \code{median}, \code{mean}, \code{se}, \code{ci_lower}, \code{ci_upper}, \code{n_eff}, \code{r_hat}. We recommend reporting the \code{mode}
for the point estimate; \code{median} and \code{mean} represent
posterior medians and means respectively.}
\item{fit}{A \code{stanfit} object (the result of fitting the RTMA model).}
}
}
\description{
Fits right-truncated meta-analysis (RTMA), a bias correction for the joint
effects of p-hacking (i.e., manipulation of results within studies to obtain
significant, positive estimates) and traditional publication bias (i.e., the
selective publication of studies with significant, positive results) in
meta-analyses.
}
\examples{
\donttest{
money_priming_rtma <- phacking_meta(money_priming_meta$yi, money_priming_meta$vi,
                                    parallelize = FALSE)
}
}
\references{
\insertRef{mathur2022phacking}{metabias}
}
