% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{rtma_cdf}
\alias{rtma_cdf}
\title{Compute theoretical and empirical CDFs for a right-truncated meta-analysis}
\usage{
rtma_cdf(rtma)
}
\arguments{
\item{rtma}{Output of \code{\link[=phacking_meta]{phacking_meta()}}.}
}
\value{
A tibble with the columns \code{yi} (effect sizes), \code{cdfi}
(their fitted CDF) and \code{ecdfi} (their empirical CDF).
}
\description{
Compute theoretical and empirical CDFs for a right-truncated meta-analysis
}
\examples{
\donttest{
money_priming_rtma <- phacking_meta(money_priming_meta$yi,
                                    money_priming_meta$vi,
                                    parallelize = FALSE)
rtma_cdf(money_priming_rtma)
}
}
\references{
\insertRef{mathur2022phacking}{metabias}
}
