% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{split_joint_distribution}
\alias{split_joint_distribution}
\title{split_joint_distribution}
\usage{
split_joint_distribution(model, rvs = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{rvs}{(str, vector) Name/names of etas to separate. If NULL, all etas that are IIVs and
non-fixed will become single. NULL is default.}
}
\value{
(Model) Reference to the same model
}
\description{
Splits etas following a joint distribution into separate distributions.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
create_joint_distribution(model, c('ETA(1)', 'ETA(2)'))
model$random_variables$etas
split_joint_distribution(model, c('ETA(1)', 'ETA(2)'))
model$random_variables$etas
}
}
\seealso{
create_joint_distribution : combine etas into a join distribution
}
