% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_model_covariates}
\alias{get_model_covariates}
\title{get_model_covariates}
\usage{
get_model_covariates(model, strings = FALSE)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{strings}{(logical) Return strings instead of symbols? FALSE (default) will give symbols}
}
\value{
(vector) Covariate symbols or names
}
\description{
List of covariates used in model

A covariate in the model is here defined to be a data item
affecting the model prediction excluding dosing items that
are not used in model code.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
get_model_covariates(model)
get_model_covariates(model, strings=TRUE)
}

}
