% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{summarize_individuals_count_table}
\alias{summarize_individuals_count_table}
\title{summarize_individuals_count_table}
\usage{
summarize_individuals_count_table(models = NULL, df = NULL)
}
\arguments{
\item{models}{(array(Model) (optional)) List of models to summarize.}

\item{df}{(data.frame) Output from a previous call to summarize_individuals.}
}
\value{
(data.frame) Table with one row per model.
}
\description{
Create a count table for individual data

Content of the various columns:

+-------------------------+------------------------------------------------------------------------------------------------+
| Column                  | Description                                                                                    |
+=========================+================================================================================================+
| \code{inf_selection}       | Number of subjects influential on model selection.                                             |
|                         | :math:\verb{\\mathrm\{OFV\}_\{parent\} - \\mathrm\{OFV\} > 3.84 \\veebar}                                    |
|                         | :math:\verb{\\mathrm\{OFV\}_\{parent\} - \\mathrm\{iOFV\}_\{parent\} - (\\mathrm\{OFV\} - \\mathrm\{iOFV\}) > 3.84} |
+-------------------------+------------------------------------------------------------------------------------------------+
| \code{inf_params}          | Number of subjects influential on parameters. predicted_dofv > 3.84                            |
+-------------------------+------------------------------------------------------------------------------------------------+
| \code{out_obs}             | Number of subjects having at least one outlying observation (CWRES > 5)                        |
+-------------------------+------------------------------------------------------------------------------------------------+
| \code{out_ind}             | Number of outlying subjects. predicted_residual > 3.0                                          |
+-------------------------+------------------------------------------------------------------------------------------------+
| \code{inf_outlier}         | Number of subjects both influential by any criteria and outlier by any criteria                |
+-------------------------+------------------------------------------------------------------------------------------------+
}
\seealso{
summarize_individuals : Get raw individual data
}
