% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_iiv}
\alias{add_iiv}
\title{add_iiv}
\usage{
add_iiv(
  model,
  list_of_parameters,
  expression,
  operation = "*",
  initial_estimate = 0.09,
  eta_names = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model to add new IIVs to.}

\item{list_of_parameters}{(array(str) or str) Name/names of parameter to add new IIVs to.}

\item{expression}{(array(str) or str) Effect/effects on eta. Either abbreviated (see above) or custom.}

\item{operation}{(str) Whether the new IIV should be added or multiplied (default).}

\item{initial_estimate}{(numeric) Value of initial estimate of parameter. Default is 0.09}

\item{eta_names}{(array(str) (optional)) Custom name/names of new eta}
}
\value{
(Model) Pharmpy model object
}
\description{
Adds IIVs to :class:\code{pharmpy.model}.

Effects that currently have templates are:
\itemize{
\item Additive (\emph{add})
\item Proportional (\emph{prop})
\item Exponential (\emph{exp})
\item Logit (\emph{log})
\item Rescaled logit (\emph{re_log})
}

For all except exponential the operation input is not needed. Otherwise user specified
input is supported. Initial estimates for new etas are 0.09.

Assuming a statement (equation could not be rendered, see API doc on website)
\itemize{
\item Additive: (equation could not be rendered, see API doc on website)
\item Proportional: (equation could not be rendered, see API doc on website)
\item Exponential: (equation could not be rendered, see API doc on website)
\item Logit: (equation could not be rendered, see API doc on website)
\item Rescaled logit: (equation could not be rendered, see API doc on website)
with (equation could not be rendered, see API doc on website)
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- remove_iiv(model, "CL")
model <- add_iiv(model, "CL", "add")
model$statements$find_assignment("CL")
}
}
\seealso{
add_pk_iiv

add_iov

remove_iiv

remove_iov
}
