% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{plot_dv_vs_ipred}
\alias{plot_dv_vs_ipred}
\title{plot_dv_vs_ipred}
\usage{
plot_dv_vs_ipred(model, predictions, stratify_on = NULL, bins = 8)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{predictions}{(data.frame) DataFrame containing the predictions}

\item{stratify_on}{(str (optional)) Name of parameter for stratification}

\item{bins}{(numeric) Number of bins for stratification}
}
\value{
(alt.Chart) Plot
}
\description{
Plot DV vs IPRED
}
\examples{
\dontrun{
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_dv_vs_ipred(model, res$predictions)
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_dv_vs_ipred(model, res$predictions, 'WGT', bins=4)
}

}
