% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phasePlaneAnalysis.R
\name{phasePlaneAnalysis}
\alias{phasePlaneAnalysis}
\title{Phase plane analysis}
\usage{
phasePlaneAnalysis(deriv, xlim, ylim, tend = 100, parameters = NULL,
  system = "two.dim", add = FALSE, state.names = if (system ==
  "two.dim") c("x", "y") else "y")
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE
system to be analysed. Discussion of the required structure of these
functions can be found in the package vignette, or in the help file for the
function \code{\link[deSolve]{ode}}.}

\item{xlim}{In the case of a two-dimensional system, this sets the limits of
the first dependent variable in any subsequent plot. In the case of a
one-dimensional system, this sets the limits of the independent variable.
Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
\code{\link[base]{length}} two.}

\item{ylim}{In the case of a two-dimensional system this sets the limits of
the second dependent variable in any subsequent plot. In the case of a
one-dimensional system, this sets the limits of the dependent variable.
Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
\code{\link[base]{length}} two.}

\item{tend}{The value of the independent variable to end any subsequent
numerical integrations at.}

\item{parameters}{Parameters of the ODE system, to be passed to \code{deriv}.
Supplied as a \code{\link[base]{numeric}} \code{\link[base]{vector}}; the
order of the parameters can be found from the \code{deriv} file. Defaults to
\code{NULL}.}

\item{system}{Set to either \code{"one.dim"} or \code{"two.dim"} to indicate
the type of system being analysed. Defaults to \code{"two.dim"}.}

\item{add}{Logical. If \code{TRUE}, the chosen features are added to an
existing plot. If \code{FALSE}, a new plot is created. Defaults to
\code{FALSE}.}

\item{state.names}{The state names for \code{\link[deSolve]{ode}} functions
that do not use positional states.}
}
\description{
Allows the user to perform a basic phase plane analysis and produce a simple
plot without the need to use the other functions directly. Specifically, a
range of options are provided and the user inputs a value to the console to
decide what is added to the plot.
}
\details{
The user designates the derivative file and other arguments as per the
above. Then the following ten options are available for execution:

\itemize{
\item 1.  Flow field: Plots the flow field of the system. See
\code{\link{flowField}}.
\item 2.  Nullclines: Plots the nullclines of the system. See
\code{\link{nullclines}}.
\item 3.  Find fixed point (click on plot): Searches for an equilibrium point
of the system, taking the starting point of the search as where the user
clicks on the plot. See \code{\link{findEquilibrium}}.
\item 4.  Start forward trajectory (click on plot): Plots a trajectory, i.e.,
a solution, forward in time with the starting point taken as where the user
clicks on the plot. See \code{\link{trajectory}}.
\item 5.  Start backward trajectory (click on plot): Plots a trajectory,
i.e., a solution, backward in time with the starting point taken as where the
user clicks on the plot. See \code{\link{trajectory}}.
\item 6.  Extend Current trajectory (a trajectory must already be plotted):
Extends already plotted trajectories further on in time. See
\code{\link{trajectory}}.
\item 7.  Local stable/unstable manifolds of a saddle (two-dimensional
systems only) (click on plot): Plots the stable and unstable manifolds of a
saddle point. The user clicks on the plot and an equilibrium point is
identified {see (3) above}, if this point is a saddle then the manifolds are
plotted. See \code{\link{drawManifolds}}.
\item 8. Grid of trajectories: Plots a set of trajectories, with the starting
points defined on an equally spaced grid over the designated plotting range
for the dependent variable(s). See \code{\link{trajectory}}.
\item 9.  Exit: Exits the current call to phasePlaneAnalysis().
\item 10. Save plot as PDF: Saves the produced plot as
"phasePlaneAnalysis.pdf" in the current working directory.
}
}
\author{
Michael J Grayling, Stephen P Ellner, John M Guckenheimer
}
