% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenoSimPlot.R
\name{phenoSimPlot}
\alias{phenoSimPlot}
\title{Plot Simulated Phenology Data}
\usage{
phenoSimPlot(z, connect, add = FALSE, col = "blue", ylim = range(z, na.rm
  = TRUE), pch = 1, lwd = 1)
}
\arguments{
\item{z}{A vector of time-series data [n x 1]}

\item{connect}{The connectivity matrix for the z vector [n x 2]. Each row contains the last and next elements of the time-series. NA values means not connected.}

\item{add}{logical value indicating whether the plot should be overlaid on the current panel.}

\item{col}{The color variable as charachter}

\item{ylim}{Range of the y axis}

\item{pch}{pch value for the symbols}

\item{lwd}{lwd value for line tickness}
}
\description{
This function plots the time-series data described with a connectivity matrix.
}
\examples{

#Simulate Phenology Data
ssSim <- phenoSim(nSites = 2, #number of sites
                  nTSet = 30, #number of time steps
                  beta = c(1, 2), #beta coefficients
                  sig = .01, #process error
                  tau = .1, #observation error
                  plotFlag = TRUE, #whether plot the data or not
                  miss = 0.05, #fraction of missing data
                  ymax = c(6, 3) #maximum of saturation trajectory
)

#Plot Simulated Data
phenoSimPlot(ssSim$z, ssSim$connect)

}
\keyword{Data}
\keyword{Phenology}
\keyword{Plot}
\keyword{Simulated}
