% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wWHIT_lambda.R
\name{v_curve}
\alias{v_curve}
\title{v_curve}
\usage{
v_curve(INPUT, lg_lambdas, d = 2, IsPlot = FALSE, wFUN = wTSM, iters = 2)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{lg_lambdas}{\code{lg} lambda vectors of Whittaker parameter.}

\item{d}{Difference order.}

\item{IsPlot}{Boolean. Whether to plot figure?}

\item{wFUN}{weights updating function, can be one of \code{\link[=wTSM]{wTSM()}},
\code{\link[=wChen]{wChen()}}, \code{\link[=wBisquare]{wBisquare()}} and \code{\link[=wSELF]{wSELF()}}.}

\item{iters}{How many times curve fitting is implemented.}
}
\description{
V-curve is used to optimize Whittaker parameter lambda.
Update 20180605 add weights updating to whittaker lambda selecting
}
\examples{
data("CA_NS6"); d = CA_NS6

# global parameter
IsPlot = TRUE
nptperyear = 23

INPUT    <- check_input(d$t, d$y, d$w, nptperyear,
                        maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
# INPUT$y0 <- d$y   # raw time-series, for visualization

lg_lambdas <- seq(0, 3, 0.1)
r <- v_curve(INPUT, lg_lambdas, d = 2, IsPlot = TRUE)
}
\keyword{internal}
