\name{plot.phenology}
\alias{plot.phenology}
\title{Plot the phenology from a result.}
\usage{
  \method{plot}{phenology} (x, ...)
}
\arguments{
  \item{x}{A result file generated by fit_phenology}

  \item{...}{Parameters used by plot_phenology}
}
\value{
  Return A list of lists with formated outputs\cr For each
  site:\cr $site=name of the site\cr $estimate1=Estimation
  of counts not taking into account the observations\cr
  $sd1=The SD of estimation1\cr $estimate2=Estimation of
  counts taking into account the observations\cr $sd2=The
  SD of estimation2
}
\description{
  The function "plot_phenology" plots the phenology graph
  from a result.
}
\details{
  plot.phenology plots the phenology.
}
\examples{
library(phenology)
# Read a file with data
# Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
# result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot, pdf=FALSE)
}
\author{
  Marc Girondot
}

