% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.ECFOCF.R
\name{logLik.ECFOCF}
\alias{logLik.ECFOCF}
\title{Return Log Likelihood of a fit done using fitCF}
\usage{
\method{logLik}{ECFOCF}(object, ...)
}
\arguments{
\item{object}{A result file generated by fitCF}

\item{...}{Not used}
}
\value{
The Log Likelihood value for the fitted model with data
}
\description{
Return Log Likelihood of a fit generated by fitCF.
}
\details{
logLik.ECFOCF return Log Likelihood of a fit done using fitCF
}
\examples{
\dontrun{
library(phenology)
# Example
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002, date0=as.Date("2002-01-01"))
par <- c(mu = 2.6404831115214353, 
        size = 0.69362774786433479, 
        mu_season = 12.6404831115214353, 
        size_season = 1.69362774786433479, 
        a2=0)
fp <- rep(0, dim(ECFOCF_2002)[3])
names(fp) <- paste0("p.", formatC(1:(dim(ECFOCF_2002)[3]), width=2, flag="0"))
par <- c(par, fp[attributes(ECFOCF_2002)$table["begin"]:attributes(ECFOCF_2002)$table["end"]])
fixed.parameters <- c(a1=Inf, p=-Inf)

 lnLCF(x=par, data=ECFOCF_2002, fixed.parameters=fixed.parameters)
 
 o_mu1season1a2p <- fitCF(x=par, fixed.parameters=fixed.parameters, 
                          data=ECFOCF_2002)
 
logLik(o_mu1season1a2p)
AIC(o_mu1season1a2p)
}
}
\seealso{
Other Model of Clutch Frequency: \code{\link{ECFOCF_f}},
  \code{\link{TableECFOCF}}, \code{\link{fitCF}},
  \code{\link{lnLCF}}, \code{\link{plot.ECFOCF}},
  \code{\link{plot.TableECFOCF}}
}
\author{
Marc Girondot
}
\concept{Model of Clutch Frequency}
