% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TableECFOCF.R
\name{plot.TableECFOCF}
\alias{plot.TableECFOCF}
\title{Plot a TableECFOCF dataset.}
\usage{
\method{plot}{TableECFOCF}(x, ..., result = "ecfocf", period = 1,
  cex.points = 4, pch = 19, col = "black", cex.axis = 0.8,
  cex.labels = 0.5, col.labels = "red", show.labels = FALSE,
  show.0 = FALSE, pch.0 = 4, cex.0 = 0.5, col.0 = "blue",
  show.scale = TRUE)
}
\arguments{
\item{x}{A CMR file summarized using TableECFOCF()}

\item{...}{Graphic parameters}

\item{result}{What should be plotted: ECFOCF or data, ECF, OCF.}

\item{period}{The period that will be plotted.}

\item{cex.points}{The maximum magnification to be used for points relative to the current setting of cex.}

\item{pch}{Character to be used for points.}

\item{col}{Color to be used for points.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex.}

\item{cex.labels}{The magnification to be used for figures.}

\item{col.labels}{Color of figures.}

\item{show.labels}{Logical to be used to show figures.}

\item{show.0}{Logical to show 0 counts.}

\item{pch.0}{Character used for 0 counts.}

\item{cex.0}{The magnification to be used for character for 0 counts.}

\item{col.0}{Color of characters for 0 counts.}

\item{show.scale}{If TRUE, show the scale as a legend}
}
\value{
Nothing
}
\description{
This function plots a CMR file summarized using TableECFOCF().\cr
}
\details{
plot.TableECFOCF plots a TableECFOCF dataset.
}
\examples{
\dontrun{
library(phenology)
# Example
data(MarineTurtles_2002)
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002)
par(mar=c(4, 4, 1, 1)+0.4)
plot(ECFOCF_2002, bty="n", las=1, cex.points=3, 
     cex.axis = 0.8, main="Year 2002")
plot(ECFOCF_2002, bty="n", las=1, cex.points=5, cex.0=0.2, 
     col="red", show.0 = TRUE, col.0="blue")
plot(ECFOCF_2002, bty="n", las=1, cex.points=3, col="lightgrey",  
     col.labels = "red", show.labels=TRUE)
plot(ECFOCF_2002, bty="n", las=1, cex.points=3, pch=NA, 
     col.labels = "red", show.labels=TRUE)
plot(ECFOCF_2002, bty="n", las=1, cex.points=3, pch=NA, 
     col.labels = "red", show.labels=TRUE, cex.0=0.2, 
     show.0 = TRUE, col.0="blue", pch.0=4)
plot(ECFOCF_2002, bty="n", las=1, result="OCF")
plot(ECFOCF_2002, bty="n", las=1, result="ECF")
plot(ECFOCF_2002, bty="n", las=1, result="ECF", type="l", main="2002 season", 
     xlab="Clutch frequency")
par(new=TRUE)
plot(ECFOCF_2002, bty="n", las=1, result="OCF", type="l", main="", 
     ylim=ScalePreviousPlot()$ylim[c("begin", "end")], 
     xlab="", ylab="", 
     col="red", 
     xaxt="n", yaxt="n", axes=FALSE)
legend("topright", legend=c("OCF", "ECF"), lty=1, col=c("red", "black"))

ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002, date0=as.Date("2002-01-01"))

plot(ECFOCF_2002, period=13)
}
}
\seealso{
Other Model of Clutch Frequency: \code{\link{ECFOCF_f}},
  \code{\link{TableECFOCF}}, \code{\link{fitCF}},
  \code{\link{lnLCF}}, \code{\link{logLik.ECFOCF}},
  \code{\link{plot.ECFOCF}}
}
\author{
Marc Girondot
}
\concept{Model of Clutch Frequency}
