% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed.parameters0.R
\name{fixed.parameters0}
\alias{fixed.parameters0}
\title{Generate a set of fixed parameters for series with only 0 counts}
\usage{
fixed.parameters0(
  series = stop("A result from add_phenology() must be provided.")
)
}
\arguments{
\item{series}{Set of series generated with add_phenology()}
}
\value{
Return a set of parameters
}
\description{
This function generates a set of fixed parameters for series with only 0 counts.\cr
The parameter series must be a result from add_phenology().
}
\details{
fixed.parameters0 generates a set of fixed parameters for series with only 0 counts
}
\examples{
\dontrun{
refdate <- as.Date("2001-01-01")
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
	reference=refdate, format="\%d/\%m/\%Y")
pfixed <- fixed.parameters0(data_Gratiot)
}
}
\author{
Marc Girondot
}
