% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phers.R
\name{getPhecodeOccurrences}
\alias{getPhecodeOccurrences}
\title{Map ICD code occurrences to phecode occurrences}
\usage{
getPhecodeOccurrences(
  icdOccurrences,
  icdPhecodeMap = phers::icdPhecodeMap,
  dxIcd = phers::diseaseDxIcdMap
)
}
\arguments{
\item{icdOccurrences}{A data.table of occurrences of ICD codes for each
person in the cohort. Must have columns \code{person_id}, \code{icd}, and \code{flag}.}

\item{icdPhecodeMap}{A data.table of the mapping between ICD codes and
phecodes. Must have columns \code{icd}, \code{phecode}, and \code{flag}. Default is the
map included in this package.}

\item{dxIcd}{A data.table of ICD codes to exclude from mapping to phecodes.
Must have columns \code{icd} and \code{flag}. Default is the table of Mendelian
diseases and the corresponding ICD codes that indicate a genetic diagnosis.
If \code{NULL}, no ICD codes will be excluded.}
}
\value{
A data.table of phecode occurrences for each person.
}
\description{
This is typically the first step of an analysis using phenotype risk scores,
the next is \code{\link[=getWeights]{getWeights()}}.
}
\examples{
library('data.table')

# map ICD codes to phecodes
phecodeOccurrences = getPhecodeOccurrences(icdSample)

# calculate weights
weights = getWeights(demoSample, phecodeOccurrences)

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()

# calculate scores
scores = getScores(
  demoSample, phecodeOccurrences, weights, diseasePhecodeMap[disease_id == diseaseId])

# calculate residual scores
rscores = getResidualScores(demoSample, scores, glmFormula = ~ sex)
}
\seealso{
\code{\link[=getWeights]{getWeights()}}, \code{\link[=getScores]{getScores()}}, \code{\link[=phers]{phers()}}
}
