% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phers.R
\name{getWeights}
\alias{getWeights}
\title{Calculate phecode-specific weights for phenotype risk scores}
\usage{
getWeights(demos, phecodeOccurrences)
}
\arguments{
\item{demos}{A data.table having one row per person in the cohort. Must have
a column \code{person_id}.}

\item{phecodeOccurrences}{A data.table of phecode occurrences for each person
in the cohort. Must have columns \code{person_id} and \code{phecode}.}
}
\value{
A data.table with columns \code{phecode}, \code{prev} (prevalence), and \code{w}
(weight). Prevalence corresponds to fraction of the cohort that has at
least one occurrence of the given phecode. Weight is calculated as \code{-log10}
prevalence.
}
\description{
This is typically the second step of an analysis using phenotype risk scores,
the next is \code{\link[=getScores]{getScores()}}.
}
\examples{
library('data.table')

# map ICD codes to phecodes
phecodeOccurrences = getPhecodeOccurrences(icdSample)

# calculate weights
weights = getWeights(demoSample, phecodeOccurrences)

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()

# calculate scores
scores = getScores(
  demoSample, phecodeOccurrences, weights, diseasePhecodeMap[disease_id == diseaseId])

# calculate residual scores
rscores = getResidualScores(demoSample, scores, glmFormula = ~ sex)
}
\seealso{
\code{\link[=getPhecodeOccurrences]{getPhecodeOccurrences()}}, \code{\link[=getScores]{getScores()}}, \code{\link[=phers]{phers()}}
}
