% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{taneja}
\alias{taneja}
\title{Taneja difference (lowlevel function)}
\usage{
taneja(P, Q, testNA, unit, epsilon)
}
\arguments{
\item{P}{a numeric vector storing the first distribution.}

\item{Q}{a numeric vector storing the second distribution.}

\item{testNA}{a logical value indicating whether or not distributions shall be checked for \code{NA} values.}

\item{unit}{type of \code{log} function. Option are 
\itemize{
\item \code{unit = "log"}
\item \code{unit = "log2"}
\item \code{unit = "log10"}   
}}

\item{epsilon}{epsilon a small value to address cases in the distance computation where division by zero occurs. In
these cases, x / 0 or 0 / 0 will be replaced by \code{epsilon}. The default is \code{epsilon = 0.00001}.
However, we recommend to choose a custom \code{epsilon} value depending on the size of the input vectors,
the expected similarity between compared probability density functions and 
whether or not many 0 values are present within the compared vectors.
As a rough rule of thumb we suggest that when dealing with very large 
input vectors which are very similar and contain many \code{0} values,
the \code{epsilon} value should be set even smaller (e.g. \code{epsilon = 0.000000001}),
whereas when vector sizes are small or distributions very divergent then
higher \code{epsilon} values may also be appropriate (e.g. \code{epsilon = 0.01}).
Addressing this \code{epsilon} issue is important to avoid cases where distance metrics
return negative values which are not defined and only occur due to the
technical issues of computing x / 0 or 0 / 0 cases.}
}
\description{
The lowlevel function for computing the taneja distance.
}
\examples{
taneja(P = 1:10/sum(1:10), Q = 20:29/sum(20:29), testNA = FALSE,
 unit = "log2", epsilon = 0.00001)
}
\author{
Hajk-Georg Drost
}
