% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDocs.R
\name{getDocs}
\alias{getDocs}
\title{Display Frequency Matrix for Phrases}
\usage{
getDocs(pd, phrs, ids = TRUE)
}
\arguments{
\item{pd}{A phraseDoc object.}

\item{phrs}{A set of phrases.}

\item{ids}{A logical value with TRUE (default) to return ids (if available), 
FALSE to return indices.}
}
\value{
A matrix with the documents and # of occurrences for the phrases in
phrs.
}
\description{
Display a frequency matrix containing all the documents that contain any of
the phrases in phrs and the number of times they occur in that document.
}
\examples{
tst=c("This is a test text",
      "This is a test text 2",
      "This is another test text",
      "This is another test text 2",
      "This girl will test text that man",
      "This boy will test text that man")
pd=phraseDoc(tst)
getDocs(pd, c("test text","another test text"))
}
