\name{rotate}
\alias{rotate}
\title{
Rotate 
}
\description{
Rotate 2D and complex-valued observations. The output is of the same kind as the input. 
}
\usage{
rotate (xy, angle, degrees = FALSE, origin = TRUE)
}
\arguments{
  \item{xy}{Either, a vector of complex-valued observations, or a matrix with 2 columns and any number of rows.} 
  \item{angle}{The desired angle of rotation, in radians.} 
  \item{degrees}{If angle of rotation is specified in degrees instead of radians, this should be set to TRUE.} 
  \item{origin}{If TRUE, points are rotated about the origin. If FALSE, points are rotated 'in place' about the mean for each dimension (i.e. the central location of the distribution).} 
}
\author{
Santiago Barreda <sbarreda@ualberta.ca>
}
\examples{

## rotate points in a 2D space 
mat = cbind (1:100, 100:1)
rotate (mat, pi/2)

## rotate complex-valued numbers
complx = complex (real = mat[,1], imaginary = mat[,2])
rotate (complx, pi/2)

}

