% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_soundfiles.R
\name{rename_soundfiles}
\alias{rename_soundfiles}
\title{Rename soundfiles}
\usage{
rename_soundfiles(
  stimuli,
  translations = NULL,
  prefix = NULL,
  suffix = NULL,
  order = NULL,
  missing = NULL,
  path,
  autonumbering = TRUE,
  backup = TRUE,
  logging = TRUE
)
}
\arguments{
\item{stimuli}{character vector of stimuli}

\item{translations}{character vector of translations (optonal). This values are added after stimuli to the new files' names so the result will be \code{...stimulus_translation...}.}

\item{prefix}{character vector of length one containing prefix for file names}

\item{suffix}{character vector of length one containing suffix for file names}

\item{order}{numeric vector that define the order of stimuli. By default the
order of the stimuli is taken.}

\item{missing}{numeric vector that define missing stimuli in case when some stimuli are not recorded.}

\item{path}{path to the directory with soundfiles.}

\item{autonumbering}{logical. If TRUE, function creates an automatic numbering of files.}

\item{backup}{logical. If TRUE, function creates backup folder with all
files. By default is TRUE.}

\item{logging}{logical. If TRUE creates a .csv file with the correspondences of old names and new names. This could be useful for restoring in case something goes wrong.}
}
\value{
no output
}
\description{
Rename soundfiles using the template from user.
}
\author{
George Moroz <agricolamz@gmail.com>
}
