% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph.R
\name{ph}
\alias{ph}
\title{Phosphor SVG Icons}
\usage{
ph(
  name,
  weight = c("light", "regular", "thin", "bold", "fill"),
  fill = "currentColor",
  rotate = NULL,
  height = "1.33em",
  width = NULL,
  vertical_align = "-0.25em",
  title = name,
  ...
)
}
\arguments{
\item{name}{Name of the icon to use.}

\item{weight}{Weight of icon (from thinnest to thickest): \code{thin}, \code{light} (default), \code{regular}, \code{bold} or \code{fill}.}

\item{fill}{Fill color for the icon, default is \code{currentColor} which should match the color of the text where the icon is used.}

\item{rotate}{Numeric, angle to rotate the icon.}

\item{height, width}{Height and width in valid CSS unit.}

\item{vertical_align}{Vertical alignment for the icon, this depend on the size of the icon.}

\item{title}{Add a \verb{<title>} tag to provides an accessible, short-text description of the icon. Use \code{NULL} for no title.}

\item{...}{Attributes passed to the SVG tag.}
}
\value{
An SVG tag.
}
\description{
Create a \verb{<svg></svg>} tag to render an icon.
}
\examples{
library(phosphoricons)

ph("airplane-tilt")
ph("airplane-tilt", weight = "thin")
ph("airplane-tilt", weight = "bold")
ph("house")
ph("house", fill = "#F45B69")
ph("cake", rotate = 45)
ph("airplane-tilt", height = 128)
ph("airplane-tilt", height = 128, weight = "fill")
ph("airplane-tilt", height = 128, weight = "fill", fill = "steelblue")
}
