% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setGenericSpct}
\alias{setGenericSpct}
\alias{setCalibrationSpct}
\alias{setRawSpct}
\alias{setCpsSpct}
\alias{setFilterSpct}
\alias{setSoluteSpct}
\alias{setReflectorSpct}
\alias{setObjectSpct}
\alias{setResponseSpct}
\alias{setSourceSpct}
\alias{setChromaSpct}
\title{Convert an R object into a spectrum object.}
\usage{
setGenericSpct(x, multiple.wl = 1L, idfactor = NULL)

setCalibrationSpct(
  x,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setRawSpct(
  x,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setCpsSpct(
  x,
  time.unit = "second",
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setFilterSpct(
  x,
  Tfr.type = c("total", "internal"),
  Rfr.constant = NA_real_,
  thickness = NA_real_,
  attenuation.mode = NA_character_,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setSoluteSpct(
  x,
  K.type = c("attenuation", "absorption", "scattering"),
  name = NA_character_,
  mass = NA_character_,
  formula = NA_character_,
  structure = grDevices::as.raster(matrix()),
  ID = NA_character_,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setReflectorSpct(
  x,
  Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setObjectSpct(
  x,
  Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setResponseSpct(
  x,
  time.unit = "second",
  response.type = "response",
  multiple.wl = 1L,
  idfactor = NULL
)

setSourceSpct(
  x,
  time.unit = "second",
  bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

setChromaSpct(x, multiple.wl = 1L, idfactor = NULL)
}
\arguments{
\item{x}{data.frame, list or generic_spct and derived classes}

\item{multiple.wl}{numeric Maximum number of repeated w.length entries with same value.}

\item{idfactor}{character Name of factor distinguishing multiple spectra when
stored logitudinally (required if mulitple.wl > 1).}

\item{strict.range}{logical Flag indicating whether off-range values result in an
error instead of a warning.}

\item{time.unit}{character string indicating the time unit used for spectral
irradiance or exposure ("second" , "day" or "exposure") or an object of
class duration as defined in package lubridate.}

\item{Tfr.type}{character A string, either "total" or "internal".}

\item{Rfr.constant}{numeric The value of the reflection factor (/1).}

\item{thickness}{numeric The thickness of the material.}

\item{attenuation.mode}{character One of "reflection", "absorption" or
"mixed".}

\item{K.type}{character A string, either "attenuation", "absorption" or
"scattering".}

\item{name}{character The name of the substance. A named character
vector, with member names such as "IUPAC" for the authority.}

\item{mass}{numeric The mass in Dalton (Da = g/mol).}

\item{formula}{character The molecular formula.}

\item{structure}{raster A bitmap of the structure.}

\item{ID}{character The name of the substance. A named character
vector, with member names such as "ChemSpider" or "PubChen" for the
authority.}

\item{Rfr.type}{character A string, either "total" or "specular".}

\item{response.type}{a character string, either "response" or "action".}

\item{bswf.used}{character A string, either "none" or the name of a BSWF.}
}
\value{
x
}
\description{
Sets the class attribute of a data.frame or an object of a derived
class to "generic_spct".
}
\section{Functions}{
\itemize{
\item \code{setCalibrationSpct}: Set class of a an object to "calibration_spct".

\item \code{setRawSpct}: Set class of a an object to "raw_spct".

\item \code{setCpsSpct}: Set class of a an object to "cps_spct".

\item \code{setFilterSpct}: Set class of an object to "filter_spct".

\item \code{setSoluteSpct}: Set class of an object to "solute_spct".

\item \code{setReflectorSpct}: Set class of a an object to "reflector_spct".

\item \code{setObjectSpct}: Set class of an object to "object_spct".

\item \code{setResponseSpct}: Set class of an object to "response_spct".

\item \code{setSourceSpct}: Set class of an object to "source_spct".

\item \code{setChromaSpct}: Set class of an object to "chroma_spct".
}}

\note{
This method alters x itself by reference and in addition
  returns x invisibly.

"internal" transmittance is defined as the transmittance of the
  material body itself, while "total" transmittance includes the effects of
  surface reflectance on the amount of light transmitted.
  For non-diffusing materials like glass an approximate \code{Rfr.constant}
  value can be used to interconvert "total" and "internal" transmittance
  values. Use \code{NA} if not known, or not applicable, e.g., for materials
  subject to internal scattering.

For non-diffusing materials like glass an approximate \code{Rfr.constant}
  value can be used to interconvert "total" and "internal" transmittance
  values. Use \code{NA} if not known, or not applicable, e.g., for materials
  subject to internal scattering.
}
\section{Warning!}{
 Not entering metadata when creating an object will limit the available
   operations!
}

\examples{
my.df <- data.frame(w.length = 300:309, s.e.irrad = rep(100, 10))
is.source_spct(my.df)
setSourceSpct(my.df)
is.source_spct(my.df)

}
\seealso{
Other set and unset spectral class functions: 
\code{\link{rmDerivedSpct}()}
}
\concept{set and unset spectral class functions}
