% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irradiance.r
\name{irradiance}
\alias{irradiance}
\title{Photon or energy irradiance from spectral energy or photon irradiance.}
\usage{
irradiance(
  w.length,
  s.irrad,
  w.band = NULL,
  unit.out = NULL,
  unit.in = "energy",
  check.spectrum = TRUE,
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL)
)
}
\arguments{
\item{w.length}{numeric Vector of wavelength (nm).}

\item{s.irrad}{numeric vector of spectral (energy) irradiances (W m-2 nm-1).}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized.}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{unit.in}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{check.spectrum}{logical Flag indicating whether to sanity check input
data, default is TRUE.}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A single numeric value or a vector of numeric values with no change
  in scale factor: [W m-2 nm-1] -> [mol s-1 m-2]
}
\description{
Energy or photon irradiance for one or more wavebands of a radiation
spectrum.
}
\note{
The last three parameters control speed optimizations. The defaults
  should be suitable in most cases. If you set \code{check.spectrum=FALSE}
  then you should call \code{check_spectrum()} at least once for your
  spectrum before using any of the other functions. If you will use
  repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector. The is no reason for
  setting \code{use.cpp.code=FALSE} other than for testing the improvement in
  speed, or in cases where there is no suitable C++ compiler for building the
  package.
}
\examples{

with(sun.data, irradiance(w.length, s.e.irrad, new_waveband(400,700), "photon"))
}
\seealso{
Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{calc_multipliers}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{insert_hinges}()},
\code{\link{integrate_xy}()},
\code{\link{interpolate_spectrum}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photon_ratio}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{s_e_irrad2rgb}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
