% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.se.band.r
\name{s_mean_se_band}
\alias{s_mean_se_band}
\alias{s_mean_se_band.default}
\alias{s_mean_se_band.generic_spct}
\alias{s_mean_se_band.filter_mspct}
\alias{s_mean_se_band.source_mspct}
\alias{s_mean_se_band.response_mspct}
\alias{s_mean_se_band.reflector_mspct}
\alias{s_mean_se_band.calibration_mspct}
\alias{s_mean_se_band.cps_mspct}
\alias{s_mean_se_band.raw_mspct}
\title{Mean plus and minus standard error from collection of spectra}
\usage{
s_mean_se_band(x, na.rm, mult, ...)

\method{s_mean_se_band}{default}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{generic_spct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{filter_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{source_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{response_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{reflector_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{calibration_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{cps_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se_band}{raw_mspct}(x, na.rm = FALSE, mult = 1, ...)
}
\arguments{
\item{x}{An R object.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{mult}{numeric number of multiples of standard error.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object is of same class as the
  members of the collection, such as \code{"filter_spct"}, containing the
  summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" mean and limits based on SEM. The spectral
values are summarised across members of a collection of spectra or of a
spectral object containing multiple spectra in long form.
}
\details{
Method specializations compute the  mean and limits based on SEM at
  each wavelength across a group of spectra stored in an object of one of the
  classes defined in package 'photobiology'. Omission of NAs is done
  separately at each wavelength. Interpolation is not applied, so all spectra
  in \code{x} must share the same set of wavelengths. An error is triggered
  if this condition is nor fulfilled. The value passed as argument to `mult`
  can be used to estimate a confidence interval for each mean value.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_mean_se_band(default)}: 

\item \code{s_mean_se_band(generic_spct)}: 

\item \code{s_mean_se_band(filter_mspct)}: 

\item \code{s_mean_se_band(source_mspct)}: 

\item \code{s_mean_se_band(response_mspct)}: 

\item \code{s_mean_se_band(reflector_mspct)}: 

\item \code{s_mean_se_band(calibration_mspct)}: 

\item \code{s_mean_se_band(cps_mspct)}: 

\item \code{s_mean_se_band(raw_mspct)}: 

}}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The methods accept
  as arguments objects of these classes only if spectra contain data for a
  single spectrometer scan. In the case of \code{cps_spct} objects, a single
  column can also contain data from multiple scans spliced into a single
  variable.
}
\examples{
s_mean_se_band(sun_evening.mspct)

}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method used for
  the computations.
}
