% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.prod.r
\name{s_prod}
\alias{s_prod}
\alias{s_prod.default}
\alias{s_prod.generic_spct}
\alias{s_prod.source_mspct}
\alias{s_prod.response_mspct}
\alias{s_prod.filter_mspct}
\alias{s_prod.reflector_mspct}
\alias{s_prod.calibration_mspct}
\alias{s_prod.cps_mspct}
\alias{s_prod.raw_mspct}
\title{Product from collection of spectra}
\usage{
s_prod(x, na.rm, ...)

\method{s_prod}{default}(x, na.rm = FALSE, ...)

\method{s_prod}{generic_spct}(x, na.rm = FALSE, ...)

\method{s_prod}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_prod}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections of
spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object is of same class as the
  members of the collection, such as \code{"filter_spct"}, containing the
  summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" product of values across members of a
collection of spectra or of a spectral object containing multiple spectra in
long form.
}
\details{
Method specializations compute the product at each wavelength across
  a group of spectra stored in an object of one of the classes defined in
  package 'photobiology'. Omission of NAs is done separately at each
  wavelength. Interpolation is not applied, so all spectra in \code{x} must
  share the same set of wavelengths. An error is triggered if this condition
  is nor fulfilled.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_prod(default)}: 

\item \code{s_prod(generic_spct)}: 

\item \code{s_prod(source_mspct)}: 

\item \code{s_prod(response_mspct)}: 

\item \code{s_prod(filter_mspct)}: 

\item \code{s_prod(reflector_mspct)}: 

\item \code{s_prod(calibration_mspct)}: 

\item \code{s_prod(cps_mspct)}: 

\item \code{s_prod(raw_mspct)}: 

}}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The methods accept
  as arguments objects of these classes only if spectra contain data for a
  single spectrometer scan. In the case of \code{cps_spct} objects, a single
  column can also contain data from multiple scans spliced into a single
  variable.

  The product operation is meaningful only for certain physical
  quantities or bases of expression.
}
\examples{
s_prod(two_filters.mspct)

}
\seealso{
See \code{\link[base]{prod}} for the \code{prod()} method used for
  the computations.
}
