% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{T2Afr}
\alias{T2Afr}
\alias{T2Afr.default}
\alias{T2Afr.filter_spct}
\alias{T2Afr.object_spct}
\alias{T2Afr.filter_mspct}
\alias{T2Afr.object_mspct}
\title{Convert transmittance into absorptance.}
\usage{
T2Afr(x, action, byref, clean, ...)

\method{T2Afr}{default}(x, action = NULL, byref = FALSE, clean = FALSE,
  ...)

\method{T2Afr}{filter_spct}(x, action = "add", byref = FALSE,
  clean = FALSE, ...)

\method{T2Afr}{object_spct}(x, action = "add", byref = FALSE,
  clean = FALSE, ...)

\method{T2Afr}{filter_mspct}(x, action = "add", byref = FALSE,
  clean = FALSE, ...)

\method{T2Afr}{object_mspct}(x, action = "add", byref = FALSE,
  clean = FALSE, ...)
}
\arguments{
\item{x}{an R object}

\item{action}{character Allowed values "replace" and "add"}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{clean}{logical replace off-boundary values before conversion}

\item{...}{not used in current version}
}
\description{
Function that coverts transmittance (fraction) into absorptance (fraction).
If reflectance (fraction) is available, it allows conversions between
internal and total absorptance.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{filter_spct}: Method for filter spectra

\item \code{object_spct}: Method for object spectra

\item \code{filter_mspct}: Method for collections of filter spectra

\item \code{object_mspct}: Method for collections of object spectra
}}

\examples{
T2Afr(Ler_leaf.spct)

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2A}}, \code{\link{T2T}},
  \code{\link{as_energy}}, \code{\link{as_quantum_mol}},
  \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
