% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.multipliers.R
\name{calc_multipliers}
\alias{calc_multipliers}
\title{Spectral weights}
\usage{
calc_multipliers(w.length, w.band, unit.out = "energy", unit.in = "energy",
  use.cached.mult = FALSE, fill = 0)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{w.band}{waveband}

\item{unit.out}{character A string: "photon" or "energy", default is "energy"}

\item{unit.in}{character A string: "photon" or "energy", default is "energy"}

\item{use.cached.mult}{logical Flag indicating whether multiplier values
should be cached between calls}

\item{fill}{numeric If fill==NA then values returned for wavelengths outside
the range of the waveband are set to NA}
}
\value{
a numeric array of multipliers of the same length as \code{w.length}
}
\description{
Calculate multipliers for selecting a range of wavelengths and optionally
applying a biological spectral weighting function (BSWF) and wavelength
normalization. This function returns numeric multipliers that can be used to
select a waveband and apply a weight.
}
\examples{
with(sun.data, calc_multipliers(w.length, new_waveband(400,700),"photon"))

}
