% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.energy.r
\name{as_energy}
\alias{as_energy}
\title{Convert spectral photon irradiance into spectral energy irradiance}
\usage{
as_energy(w.length, s.qmol.irrad)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{s.qmol.irrad}{numeric Corresponding vector of spectral photon
irradiances}
}
\value{
A numeric vector of spectral (energy) irradiances
}
\description{
For example an spectrum [mol s-1 m-2 nm-1] is converted into a spectrum [W
m-2 nm-1]
}
\examples{
with(sun.spct, as_energy(w.length, s.q.irrad))

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2Afr}}, \code{\link{T2A}},
  \code{\link{T2T}}, \code{\link{as_quantum_mol}},
  \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
