% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.trim.r
\name{trim_wl}
\alias{trim_wl}
\alias{trim_wl.default}
\alias{trim_wl.generic_spct}
\alias{trim_wl.generic_mspct}
\alias{trim_wl.waveband}
\alias{trim_wl.list}
\title{Trim head and/or tail of a spectrum}
\usage{
trim_wl(x, range, use.hinges, fill, ...)

\method{trim_wl}{default}(x, range, use.hinges, fill, ...)

\method{trim_wl}{generic_spct}(x, range = NULL, use.hinges = TRUE,
  fill = NULL, ...)

\method{trim_wl}{generic_mspct}(x, range = NULL, use.hinges = TRUE,
  fill = NULL, ...)

\method{trim_wl}{waveband}(x, range = NULL, use.hinges = TRUE,
  fill = NULL, trim = getOption("photobiology.waveband.trim", default =
  TRUE), ...)

\method{trim_wl}{list}(x, range = NULL, use.hinges = TRUE, fill = NULL,
  trim = getOption("photobiology.waveband.trim", default = TRUE), ...)
}
\arguments{
\item{x}{an R object}

\item{range}{a numeric vector of length two, or any other object for which
function range() will return two}

\item{use.hinges}{logical, if TRUE (the default) wavelengths in nm.}

\item{fill}{if \code{fill == NULL} then tails are deleted, otherwise tails
are filled with the value of fill.}

\item{...}{not used}

\item{trim}{logical (default is TRUE which trims the wavebands at the
boundary, while FALSE discards wavebands that are partly off-boundary).}
}
\value{
A copy of \code{x}, usually trimmed or expanded to a different
  length, either shorter or longer. Possibly with some of the original
  spectral data values replaced with \code{fill}.
}
\description{
Triming of head and tail of a spectrum based on wavelength limits,
interpolation used by default. Expansion is also possible.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{generic_spct}: Trim an object of class "generic_spct" or derived.

\item \code{generic_mspct}: Trim an object of class "generic_mspct" or derived.

\item \code{waveband}: Trim an object of class "waveband".

\item \code{list}: Trim a list (of "waveband" objects).
}}

\note{
By default the \code{w.length} values for the first and last rows
  in the returned object are the values supplied as \code{range}.

trim_wl when applied to waveband objects always inserts hinges when
  trimming.

trim_wl when applied to waveband objects always inserts hinges when
  trimming.
}
\examples{
trim_wl(sun.spct, range = c(400, 500))
trim_wl(sun.spct, range = c(NA, 500))
trim_wl(sun.spct, range = c(400, NA))

}
\seealso{
Other trim functions: \code{\link{clip_wl}},
  \code{\link{trim_spct}}, \code{\link{trim_tails}},
  \code{\link{trim_waveband}}
}
