% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.waveband.r
\name{trim_waveband}
\alias{trim_waveband}
\title{Trim (or expand) head and/or tail}
\usage{
trim_waveband(w.band, range = NULL, low.limit = 0, high.limit = Inf,
  trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = TRUE)
}
\arguments{
\item{w.band}{an object of class "waveband" or a list of such objects.}

\item{range}{a numeric vector of length two, or any other object for which
function range() will return a numeric vector of two wavelengths (nm).}

\item{low.limit}{shortest wavelength to be kept (defaults to 0 nm).}

\item{high.limit}{longest wavelength to be kept (defaults to Inf nm).}

\item{trim}{logical (default is TRUE which trims the wavebands at the
boundary, while FALSE discards wavebands that are partly off-boundary).}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A waveband object or a list of waveband objects trimmed or filtered
  depending on whether a single waveband object or a list of waveband
  objects was supplied as argument to formal parameter \code{w.band}.
}
\description{
Trimming of waveband boundaries can be required needed when the spectral data
does not cover the whole waveband.
}
\examples{
VIS <- waveband(c(380, 760)) # nanometres

trim_waveband(VIS, c(400,700))
trim_waveband(VIS, low.limit = 400)
trim_waveband(VIS, high.limit = 700)

}
\seealso{
Other trim functions: \code{\link{clip_wl}},
  \code{\link{trim_spct}}, \code{\link{trim_wl}}
}
