% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindspct.r
\name{Extract}
\alias{$<-.generic_spct}
\alias{Extract}
\alias{[.chroma_spct}
\alias{[.cps_spct}
\alias{[.filter_spct}
\alias{[.generic_spct}
\alias{[.object_spct}
\alias{[.raw_spct}
\alias{[.reflector_spct}
\alias{[.response_spct}
\alias{[.source_spct}
\alias{[<-.generic_spct}
\title{Extract or replace parts of a spectrum}
\usage{
\method{[}{generic_spct}(x, i, j, drop = NULL)

\method{[}{raw_spct}(x, i, j, drop = NULL)

\method{[}{cps_spct}(x, i, j, drop = NULL)

\method{[}{source_spct}(x, i, j, drop = NULL)

\method{[}{response_spct}(x, i, j, drop = NULL)

\method{[}{filter_spct}(x, i, j, drop = NULL)

\method{[}{reflector_spct}(x, i, j, drop = NULL)

\method{[}{object_spct}(x, i, j, drop = NULL)

\method{[}{chroma_spct}(x, i, j, drop = NULL)

\method{[}{generic_spct}(x, i, j) <- value

\method{$}{generic_spct}(x, name) <- value
}
\arguments{
\item{x}{spectral object from which to extract element(s) or in which to replace element(s)}

\item{i}{index for rows,}

\item{j}{index for columns, specifying elements to extract or replace. Indices are
numeric or character vectors or empty (missing) or NULL. Please, see
\code{\link[base]{Extract.data.frame}} for more details.}

\item{drop}{logical. If TRUE the result is coerced to the lowest possible
dimension. The default is FALSE unless the result is a single column.}

\item{value}{A suitable replacement value: it will be repeated a whole number
of times if necessary and it may be coerced: see the Coercion section. If
NULL, deletes the column if a single column is selected.}

\item{name}{A literal character string or a name (possibly backtick quoted).
For extraction, this is normally (see under ‘Environments’) partially
matched to the names of the object.}
}
\value{
An object of the same class as \code{x} but containing only the
  subset of rows and columns that are selected. See details for special
  cases.
}
\description{
Just like extraction and replacement with indexes in base R, but preserving
the special attributes used in spectral classes and checking for validity of
remaining spectral data.
}
\details{
These methods are just wrappers on the method for data.frame objects
  which copy the additional attributes used by these classes, and validate
  the extracted object as a spectral object. When drop is TRUE and the
  returned object has only one column, then a vector is returned. If the
  extrated columns are more than one but do not include \code{w.length}, a
  data frame is returned instead of a spectral object.
}
\examples{
sun.spct[sun.spct$w.length > 400, ]
subset(sun.spct, w.length > 400)

tmp.spct <- sun.spct
tmp.spct[tmp.spct$s.e.irrad < 1e-5 , "s.e.irrad"] <- 0
e2q(tmp.spct[ , c("w.length", "s.e.irrad")]) # restore data consistency!

}
\seealso{
\code{\link[base]{subset.data.frame}} and \code{\link{trim_spct}}
}

