#' Spectral data for LEDs array supplied by Osram
#' 
#' Datasets containing the wavelengths and tabulated values spectral emittance 
#' for the NHXRGB0905005 light emitting diodes (LEDs) arrays from Osram. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)  
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' osram
#' leds.mspct[osram]
#' 
#' @note 
#' Current trade name is Osram Opto Semiconductors
#' \url{http://www.osram-os.com/}
#' 
"osram"
