#' Spectral data for Lamps from different suppliers
#' 
#' The collection of spectra \code{\link{lamps.mspct}} contains spectra for 
#' light bulds, luminaires and other ready-to-use lamps from various current
#' and former suppliers. The character
#' vectors described here contain the names of the spectra for lamps from each
#' brand to facilitate their extraction from the collection. One
#' additional vector, \code{lamp_brands} contains the names of the brands as used
#' in the names of the spectra in the collection.
#' 
#' @note Some of the lamps are from resellers' brands, usually obscure ones, and
#'   others are from well-known brands. Some of the brands have changed 
#'   ownership through take-overs and merges. When known the vintage is 
#'   indicated in the comment field of each spectrum. Multiple brands may also
#'   belong to the same company.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples
#' lamp_brands
#' Osram_lamps
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
"lamp_brands"

#' @rdname lamp_brands
#' 
#' @section Osram:
#' Lamps branded Osram are currently sold by Ledvance, of Chinese ownership.
#' Osram currently makes and sells other products. When Osram (Germany) and
#' Sylvania (USA) merged years back both brands remained in use in different
#' markets and many types of lamps remained differentiated.
#'  .
#' @references \url{https://www.ledvance.com/}
#' 
"Osram_lamps"

#' @rdname lamp_brands
#' 
#' @section Philips:
#' Lamps branded Philips are sold by Signify Netherlands B.V.
#' 
#' @references \url{https://www.lighting.philips.com/main/home}
#' 
"Philips_lamps"

#' @rdname lamp_brands
#' 
#' @section Sylvania:
#' Lamps branded Sylvania are currently sold by Ledvance in the USA, of Chinese
#' ownership. Osram currently makes and sells other products. When Osram
#' (Germany) and Sylvania (USA) merged years back both brands remained in use in
#' different markets and many types of lamps remained differentiated.
#' 
#' @references \url{https://www.ledvanceus.com/Pages/default.aspx}
#' 
"Sylvania_lamps"

#' @rdname lamp_brands
#' 
#' @section Q-LAB:
#' Q-Lab Corporation is a global provider of material durability testing 
#' products including UV-B and UV-A lamps used in test cabinets.
#' 
#' @references \url{https://www.q-lab.com/}
#' 
"QPanel_lamps"

#' @rdname lamp_brands
#' 
#' @section Airam:
#' Airam Electric Oy Ab is Finnish supplier and manufacturer of lamps and
#' luminaires. 
#' 
#' @references \url{https://www.airam.fi/en/}
#' 
"Airam_lamps"

#' @rdname lamp_brands
#' 
#' @section Toshiba:
#' Lamps branded Toshiba are sold by Toshiba Lighting.
#' 
#' @references \url{https://www.tlt.co.jp/tlt/index_e.htm}
#' 
"Toshiba_lamps"

#' @rdname lamp_brands
#' 
#' @section Aputure:
#' Aputure is a Chinese supplier of LED lighting and related equipment for filmmaking.
#' 
#' @references \url{https://www.aputure.com/}
#' 
"Aputure_lamps"

#' @rdname lamp_brands
#' 
#' @section Sunwayfoto:
#' Sunwayfoto is a Chinese supplier of ancillary equipment for photography,
#' including battery-powered fill-in LED lights with high CRI ratings..
#' 
#' @references \url{https://www.sunwayfoto.com/}
#' 
"Sunwayfoto_lamps"

#' @rdname lamp_brands
#' 
#' @section Godox:
#' Godox is a Chinese supplier of photography and video lighting equipment. They
#' sell both LED lights and Xenon flashes of a wide range to output power.
#' 
#' @references \url{https://www.godox.com/}
#' 
"Godox_lamps"

#' @rdname lamp_brands
#' 
#' @section Valoya:
#' Valoya Oy (Finland) sells LED lamps and luminaires for commercial plant 
#' cultivation. Both for indoor cultivation and to supplement sunlight in
#' greenhouses.
#' 
#' @references \url{https://www.valoya.com/}
#' 
"Valoya_lamps"

#' @rdname lamp_brands
#' 
#' @section Fluence:
#' Fluence, a division of Osram, sells LED luminaires for commercial plant 
#' cultivation. Both for indoor cultivation and to supplement sunlight in
#' greenhouses.
#' 
#' @references \url{https://fluence-led.com/}
#' 
"Fluence_lamps"

#' @rdname lamp_brands
#' 
#' @section Convoy:
#' Is a Chinese supplier of LED flashlights/torches and their parts. Sold
#' through AliExpress, eBay and Banggood.
#' 
"Convoy_lamps"

#' @rdname lamp_brands
#' 
#' @section Jaxman:
#' Is a Chinese supplier of LED flashlights/torches. Formerly sold
#' through AliExpress.
#' 
"Jaxman_lamps"

#' @rdname lamp_brands
#' 
#' @section Generic, shop branded or distributor branded:
#' We group under this category shop-branded or generic (no-brand) lamps that
#' usually have specifications with limited details. These lamps are unlikely to
#' remain consistent from batch to batch or have limited availability.
#' 
"Generic_lamps"
