#' Rhinogrades traits
#'
#' A simulated dataset, as used by Gonzalez-Voyer and Von Hardenberg as an
#' example, containing variables on body mass (BM), litter size (LS), nose
#' length (NL), dispersal distance (DD) and range size (RS).
#'
#' @source > Gonzalez-Voyer A & von Hardenberg A. 2014. An Introduction to
#'   Phylogenetic Path Analysis. Chapter 8. In: Garamszegi LZ (ed.), Modern
#'   Phylogenetic Comparative Methods and Their Application in Evolutionary
#'   Biology. pp. 201-229. Springer-Verlag Berlin Heidelberg.
#'   <doi:10.1111/j.1558-5646.2012.01790.x>
"rhino"

#' Rhinogrades phylogeny
#'
#' A phylogenetic tree for the 100 species of the \code{rhino} dataset.
#'
#' @source > Gonzalez-Voyer A & von Hardenberg A. 2014. An Introduction to
#'   Phylogenetic Path Analysis. Chapter 8. In: Garamszegi LZ (ed.), Modern
#'   Phylogenetic Comparative Methods and Their Application in Evolutionary
#'   Biology. pp. 201-229. Springer-Verlag Berlin Heidelberg.
#'   <doi:10.1111/j.1558-5646.2012.01790.x>
"rhino_tree"

