% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.check.R
\name{arg.check}
\alias{arg.check}
\title{Check for missing arguments in function call}
\usage{
arg.check(
  call,
  arguments = c("LR", "inv.R", "branch.length", "n.descen", "tree")
)
}
\arguments{
\item{call}{match.call(). To get function call with all of the specified
arguments and their full names.}

\item{arguments}{character. Arguments to be checked}
}
\value{
logical
}
\description{
Check for missing arguments using function call and a provided
vector with argument names to check
}
\examples{
\donttest{
geop <- function(x, tree, ...){
                f4 <- arg.check(match.call(),
                                c("LR", "inv.R",
                                "branch.length", "n.descen"))
                f1 <- arg.check(match.call(),
                                c("tree"))
                c(f1, f4)
                }
geop(1, 1)
geop(1)
geop(1, LR=1)
}
}
\author{
Neander Marcel Heming
}
