% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_tmb.R
\name{fit_tmb}
\alias{fit_tmb}
\title{Optimize a TMB model}
\usage{
fit_tmb(
  obj,
  fn = obj$fn,
  gr = obj$gr,
  startpar = NULL,
  lower = -Inf,
  upper = Inf,
  getsd = TRUE,
  control = list(eval.max = 10000, iter.max = 10000, trace = 1),
  bias.correct = FALSE,
  bias.correct.control = list(sd = FALSE, split = NULL, nsplit = NULL, vars_to_correct =
    NULL),
  savedir = NULL,
  loopnum = 2,
  newtonsteps = 0,
  n = Inf,
  getReportCovariance = FALSE,
  getJointPrecision = FALSE,
  getHessian = FALSE,
  quiet = FALSE,
  start_time_elapsed = as.difftime("0:0:0"),
  ...
)
}
\arguments{
\item{obj}{The compiled TMB object}

\item{fn}{Function to be minimized. Must return a scalar value. .}

\item{gr}{Optional function that takes the same arguments as objective and evaluates the gradient of objective at its first argument. Must return a vector as long as startpar}

\item{startpar}{Starting values for fixed effects (default NULL uses \code{obj$par})}

\item{lower, upper}{
    vectors of lower and upper bounds, replicated to be as long as
    \code{start}.  If unspecified, all parameters are assumed to be
    unconstrained.
  }

\item{getsd}{Boolean indicating whether to run standard error calculation; see \code{\link[TMB]{sdreport}} for details}

\item{control}{A list of control parameters. For details see \code{\link[stats]{nlminb}}}

\item{bias.correct}{Boolean indicating whether to do epsilon bias-correction;
see \code{\link[TMB]{sdreport}} and \code{\link{fit_tmb}}for details}

\item{bias.correct.control}{tagged list of options for epsilon bias-correction,
where \code{vars_to_correct} is a character-vector of ADREPORT variables that should be bias-corrected}

\item{savedir}{directory to save results (if \code{savedir=NULL}, then results aren't saved)}

\item{loopnum}{number of times to re-start optimization (where \code{loopnum=3}
sometimes achieves a lower final gradient than \code{loopnum=1})}

\item{newtonsteps}{Integer specifying the number of extra newton steps to take
after optimization (alternative to \code{loopnum}).
Each newtonstep requires calculating the Hessian matrix and is therefore slow.
But for well-behaved models, each Newton step will typically
decrease the maximum gradient of the loglikelihood with respect to each fixed effect,
and therefore this option can be used to achieve an arbitrarily low final gradient
given sufficient time for well-behaved models.  However, this option will also
perform strangely or have unexpected consequences for poorly-behaved models, e.g.,
when fixed effects are at upper or lower bounds.}

\item{n}{sample sizes (if \code{n!=Inf} then \code{n} is used to calculate BIC and AICc)}

\item{getReportCovariance}{Get full covariance matrix of ADREPORTed variables?}

\item{getJointPrecision}{Optional. Return full joint precision matrix of random effects and parameters?}

\item{getHessian}{return Hessian for usage in later code}

\item{quiet}{Boolean whether to print additional messages results to terminal}

\item{start_time_elapsed}{how much time has elapsed prior to calling fit_tmb,
for use, e.g., when calling \code{fit_tmb} multiple times in sequence,
where \code{start_time_elapsed = opt_previous$time_for_run}}

\item{...}{list of settings to pass to \code{\link[TMB]{sdreport}}}
}
\value{
the standard output from \code{\link[stats]{nlminb}}, except with additional diagnostics and timing info,
        and a new slot containing the output from \code{\link[TMB]{sdreport}}
}
\description{
\code{fit_tmb} runs a TMB model and generates standard diagnostics
}
\references{
For more details see \doi{10.1016/j.fishres.2015.11.016}
}
