%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  ./PhyloSimSource.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{setInsertHook.GeneralInsertor}
\alias{setInsertHook.GeneralInsertor}
\alias{GeneralInsertor.setInsertHook}
\alias{setInsertHook.GeneralInsertor}
\alias{setInsertHook,GeneralInsertor-method}


 \title{Set the insert hook function}

 \description{
	Set the insert hook function.

	The insert hook allows to make various modifications on the insert before performing the insertion.
	The function must have the following arguments: seq (the sequence object to insert), target.seq (the target Sequence object),
	event.pos (the position of the site which generated the insertion event), insert.pos (the position of the insertion).

	The insert hook function is called by the insertion event handler function. The insert hook takes the
	sequence generated by the \code{generateInsert} method throught the "seq" argument. The function
	must return a Sequnece object, which will be inserted in the target sequence.
 }

 \usage{\method{setInsertHook}{GeneralInsertor}(this, value, ...)}

 \arguments{
 	\item{this}{A GeneralInsertor object.}
 	\item{value}{A function object.}
 	\item{...}{Not used.}
 }

 \value{
 	The function object.
 }

 \examples{
	# create a GeneralInsertor object
	i<-GeneralInsertor(
		rate=0.5,
		propose.by=function(process){sample(c(5:10),1)}, # inserts between 5 and 10
		template.seq=NucleotideSequence(length=5,processes=list(list(JC69())))
	)
	# set a dummy insert hook
	setInsertHook(i,function(seq){return(seq)})
	# set a new insert hook via virtual field
	i$insertHook<-function(seq){
		seq$processes<-list(list(GTR())) # replace the subsitution process
		return(seq)
	}
	# get the insert hook via virtual field
	i$insertHook
	# get the insert hook
	getInsertHook(i)
 }

 \author{Botond Sipos}

 \seealso{
 	For more information see \code{\link{GeneralInsertor}}.
 }
