% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-special.R
\name{is_txid_in_sq}
\alias{is_txid_in_sq}
\title{Is txid in sequence?}
\usage{
is_txid_in_sq(phylota, txid, sid)
}
\arguments{
\item{phylota}{Phylota}

\item{txid}{Taxonomic ID}

\item{sid}{Sequence ID}
}
\value{
boolean
}
\description{
Checks if given txid is represented by sequence by
looking at sequence source organism's lineage.
}
\examples{
data(tinamous)
sid <- tinamous@sids[[1]]
sq <- tinamous[[sid]]
txid <- sq@txid
# expect true
is_txid_in_sq(phylota = tinamous, txid = txid, sid = sid)
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_sq_slot}},
  \code{\link{get_stage_times}}, \code{\link{get_tx_slot}},
  \code{\link{get_txids}}, \code{\link{is_txid_in_clstr}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
