% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.outliers.R
\name{detect.outliers}
\alias{detect.outliers}
\alias{detect.outliers.array}
\title{Detection of outliers in 1D and 2D data}
\usage{
detect.outliers(X, k = 3, test.island = TRUE, normalizeby = "row")

detect.outliers.array(arr, nbsp, k = 3)
}
\arguments{
\item{X}{2D matrix (gene x species) obtained with the \code{Dist2WR()} function.}

\item{k}{strength of outlier detection. High values (typically 3) 
correspond to less outliers detected than with lower ones (e.g. 1.5).}

\item{test.island}{should islands of outliers be treated as such. 
If TRUE (the default), only the highest value in an island of outliers is
removed. This prevents erroneous outliers due to hicthiking effect to be removed.}

\item{normalizeby}{Should the 2D matrix be normalized prior to outlier detection, and how.
Can be "row" (the default),"col" or "none". Normalization is done by dividing columns or rows 
by their median.}

\item{arr}{Array of values, typically the weight of each gene matrix (alpha values).}

\item{nbsp}{Number of species in the analysis}
}
\value{
\code{detect.outliers}: A matrix with outliers detected in the 2D matric. Each row \code{x} contains the 
gene (\code{x[1]}) where the species (\code{x[2]}) is an outlier.

\code{detect.outliers.array}: An array listing the outliers detected (if any)
}
\description{
Functions to detect outliers, in matrices or in arrays.
}
\details{
These functions detect outliers either in matrices or in arrays. For the method 
to be adapted to skewed data, as is the case here, the outlier detection 
method used is the adjusted Tukey proposed by Hubert and Vandervieren (2008).
}
\section{Functions}{
\itemize{
\item \code{detect.outliers()}: detect outliers in 2D matrix

\item \code{detect.outliers.array()}: detects outliers in 1D array

}}
\examples{
# Get the initial gene x species matrix
# from the carnivora dataset
data(carnivora) 
mat <- phylter(carnivora, InitialOnly = TRUE, parallel = FALSE)$WR

# detect outliers in this matrix
outliers<-detect.outliers(mat)
outliers$cells # matrix where each row represents one cell in the input matrix

}
\references{
de Vienne D.M., Ollier S. et Aguileta G. (2012) Phylo-MCOA: 
A Fast and Efficient Method to Detect Outlier Genes and Species
in Phylogenomics Using Multiple Co-inertia Analysis. Molecular 
Biology and Evolution 29 : 1587-1598.

Hubert, M. and Vandervieren, E. (2008). An adjusted boxplot for skewed
distributions. Computational Statistics and Data Analysis, 52, 5186-5201.
}
