# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get mean atmospheric pressure at given altitude in kPa
#' @param altitude_m Altitude above mean sea level in meters
#' @return Pressure in pascals
#' @examples
#' pres_atm_kPa(-430.5) # Dead Sea
#' pres_atm_kPa(0)
#' pres_atm_kPa(3440) # Namche Bazaar
#' pres_atm_kPa(4260) # Dingboche
#' pres_atm_kPa(5364) # Everest Base Camp
#' pres_atm_kPa(6000) # Camp 1
#' pres_atm_kPa(6400) # Camp 2
#' pres_atm_kPa(7200) # Camp 3
#' pres_atm_kPa(7950) # Camp 4
#' pres_atm_kPa(8850) # Everest summit
#' pres_atm_frac(8850) # fraction of sea level pressure on Everest
#' @references
#' Below 51 km: Practical Meteorology by Roland Stull, pg 12. Above 51 km:
#' \url{http://www.braeunig.us/space/atmmodel.htm} Validation data:
#' \url{https://www.avs.org/AVS/files/c7/c7edaedb-95b2-438f-adfb-36de54f87b9e.pdf}
#' @concept atmospheric pressure
#' @export
pres_atm_kPa <- function(altitude_m) {
    .Call(`_physiology_pres_atm_kPa`, altitude_m)
}

#' @describeIn pres_atm_kPa Get fraction of mean atomspheric pressure at sea level
#' @export
pres_atm_frac <- function(altitude_m) {
    .Call(`_physiology_pres_atm_frac`, altitude_m)
}

getGeopotential <- function(altitude_km) {
    .Call(`_physiology_getGeopotential`, altitude_km)
}

#' @title get standard temperature at a given altitude
#' @description `altitude_km = earth_radius * altitude / (earth_radius +
#' altitude)` All in km Temperature is in Kelvin.
#' @seealso \code{\link{pres_atm_kPa}}
#' @param altitude_km Altitude in kilometers
#' @md
#' @keywords internal
getStandardTemperature <- function(altitude_km) {
    .Call(`_physiology_getStandardTemperature`, altitude_km)
}

getStandardPressure <- function(altitude_m) {
    .Call(`_physiology_getStandardPressure`, altitude_m)
}

