% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_piece_images.R
\name{save_piece_images}
\alias{save_piece_images}
\title{Save piecepack images}
\usage{
save_piece_images(
  cfg = getOption("piecepackr.cfg", pp_cfg()),
  directory = tempdir(),
  format = "svg",
  angle = 0
)
}
\arguments{
\item{cfg}{Piecepack configuration list}

\item{directory}{Directory where to place images}

\item{format}{Character vector of formats to save images in}

\item{angle}{Numeric vector of angles to rotate images (in degrees)}
}
\description{
Saves images of all individual piecepack pieces.
}
\examples{
  \donttest{
    if (all(capabilities(c("cairo", "png")))) {
        cfg <- pp_cfg(list(suit_color="darkred,black,darkgreen,darkblue,grey"))
        save_piece_images(cfg, directory=tempdir(), format="svg", angle=0)
        save_piece_images(cfg, directory=tempdir(), format="png", angle=90)
    }
  }
}
