% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_fns.R
\name{grid_shape_grobs}
\alias{grid_shape_grobs}
\alias{halmaGrob}
\alias{kiteGrob}
\alias{pyramidGrob}
\alias{convexGrobFn}
\alias{concaveGrobFn}
\title{Grid shape grob utility functions}
\usage{
halmaGrob(name = NULL, gp = gpar(), vp = NULL)

kiteGrob(name = NULL, gp = gpar(), vp = NULL)

pyramidGrob(name = NULL, gp = gpar(), vp = NULL)

convexGrobFn(n_vertices, t)

concaveGrobFn(n_vertices, t, r = 0.2)
}
\arguments{
\item{name}{A character identifier (for grid)}

\item{gp}{An object of class ‘gpar’, typically the output from a call
to the function ‘gpar’.  This is basically a list of
graphical parameter settings.}

\item{vp}{A \code{grid} viewport object (or NULL).}

\item{n_vertices}{Number of vertices}

\item{t}{Angle (in degrees) of first vertex of shape}

\item{r}{Radial distance (from 0 to 0.5)}
}
\description{
Utility functions that produce grobs of various shapes
or function that returns a function that produces a grob.
These are usually wrappers of \code{polygonGrob} or \code{pathGrob}.
}
\examples{
  if(require("grid")) {
      gp <- gpar(col="black", fill="yellow")

      vp <- viewport(x=1/3-1/6, width=1/3)
      grid.draw(halmaGrob(gp=gp, vp=vp))
      vp <- viewport(x=2/3-1/6, width=1/3)
      grid.draw(pyramidGrob(gp=gp, vp=vp))
      vp <- viewport(x=3/3-1/6, width=1/3)
      grid.draw(kiteGrob(gp=gp, vp=vp))

      grid.newpage()
      vp <- viewport(x=1/4, y=1/4, width=1/2, height=1/2)
      grid.draw(convexGrobFn(3, 0)(gp=gp, vp=vp))
      vp <- viewport(x=3/4, y=1/4, width=1/2, height=1/2)
      grid.draw(convexGrobFn(4, 90)(gp=gp, vp=vp))
      vp <- viewport(x=3/4, y=3/4, width=1/2, height=1/2)
      grid.draw(convexGrobFn(5, 180)(gp=gp, vp=vp))
      vp <- viewport(x=1/4, y=3/4, width=1/2, height=1/2)
      grid.draw(convexGrobFn(6, 270)(gp=gp, vp=vp))

      grid.newpage()
      vp <- viewport(x=1/4, y=1/4, width=1/2, height=1/2)
      grid.draw(concaveGrobFn(3, 0, 0.1)(gp=gp, vp=vp))
      vp <- viewport(x=3/4, y=1/4, width=1/2, height=1/2)
      grid.draw(concaveGrobFn(4, 90, 0.2)(gp=gp, vp=vp))
      vp <- viewport(x=3/4, y=3/4, width=1/2, height=1/2)
      grid.draw(concaveGrobFn(5, 180, 0.3)(gp=gp, vp=vp))
      vp <- viewport(x=1/4, y=3/4, width=1/2, height=1/2)
      grid.draw(concaveGrobFn(6, 270)(gp=gp, vp=vp))
  }

}
