% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_cfg.R
\name{pp_cfg}
\alias{pp_cfg}
\alias{is_pp_cfg}
\alias{as_pp_cfg}
\title{Configuration list R6 object}
\usage{
pp_cfg(cfg = list())

is_pp_cfg(cfg)

as_pp_cfg(cfg = list())
}
\arguments{
\item{cfg}{List of configuration options}
}
\description{
\code{pp_cfg} and \code{as_pp_cfg} creates piecepack configuration list R6 object.
\code{is_pp_cfg} returns \code{TRUE} if object is a piecepack configuration list R6 object.
\code{as.list} will convert it into a list.
}
\details{
\code{pp_cfg} objects serve the following purposes:\enumerate{
\item{Customize the appearance of pieces drawn by \code{grid.piece}.}
\item{Speed up the drawing of graphics through use of caching.}
\item{Allow the setting and querying of information about the board game components
      that maybe of use to developers\enumerate{
         \item{Number of suits}
         \item{Number of ranks}
         \item{Suit colors}
         \item{Which types of components are included and/or properly supported}
         \item{What would be a good color to use when adding annotations on top of these components.}
         \item{Title, Description, Copyright, and Credit metadata}
      }}}
}
\section{\code{pp_cfg} R6 Class Method Arguments}{
\describe{
  \item{\code{piece_side}}{A string with piece and side separated by a underscore e.g. "coin_face".}
  \item{\code{suit}}{Number of suit (starting from 1).}
  \item{\code{rank}}{Number of rank (starting from 1).}
  \item{\code{type}}{Which type of grob to return, either \code{"normal"}, \code{"picture"}, or \code{"raster"}.}
}
}

\section{\code{pp_cfg} R6 Class Methods}{
\describe{
  \item{\code{get_grob}}{Returns a \code{grid} \dQuote{grob} for drawing the piece.}
  \item{\code{get_piece_opt}}{Returns a list with info useful for drawing the piece.}
  \item{\code{get_suit_color}}{Returns the suit colors.}
  \item{\code{get_width}, \code{get_height}, \code{get_depth}}{
        Dimensions (of the bounding cube) of the piece in inches}
}
}

\examples{
 cfg <- pp_cfg(list(invert_colors=TRUE))
 as.list(cfg)
 is_pp_cfg(cfg)
 as_pp_cfg(list(suit_color="darkred,black,darkgreen,darkblue,grey"))
 cfg$get_suit_color(suit=3)
 cfg$annotation_color
 cfg$has_matchsticks
 cfg$has_matchsticks <- TRUE
 cfg$has_matchsticks
 cfg$get_width("tile_back")
 cfg$get_height("die_face")
 cfg$get_depth("coin_face")
 \donttest{
   cfg <- list()
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
   cfg <- pp_cfg(list())
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
 }

}
\seealso{
\url{https://trevorldavis.com/piecepackr/configuration-lists.html} for more details
     about \code{piecepackr} configuration lists.
 \code{\link{game_systems}} for functions that return
     configuration list objects for several game systems.
}
